(define/contract (min-drones-mismatch target source)
  (-> (listof (listof exact-integer?)) (listof (listof exact-integer?)) exact-integer?)
  (let ([ht (make-hash)])
    (for ([t target])
      (let ([key (format "~a-~a" (car t) (cadr t))])
        (hash-set! ht key (add1 (hash-ref ht key 0)))))
    (for ([s source])
      (let ([key (format "~a-~a" (car s) (cadr s))])
        (hash-set! ht key (sub1 (hash-ref ht key 0)))))
    (quotient (apply + (filter positive? (hash-values ht))) 2))